/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.data.listener;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.redpxnda.nucleus.datapack.references.GameEventReference;
import com.redpxnda.nucleus.datapack.references.entity.PlayerReference;
import com.redpxnda.nucleus.datapack.references.item.ItemStackReference;
import com.redpxnda.nucleus.datapack.references.storage.Vec3Reference;
import com.redpxnda.respawnobelisks.config.ChargeConfig;
import com.redpxnda.respawnobelisks.data.listener.ROBEReference;
import com.redpxnda.respawnobelisks.registry.block.entity.RespawnObeliskBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.util.TriConsumer;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;

public class ObeliskInteraction {
    public static Map<GameEvent, Map<ResourceLocation, ObeliskInteraction>> EVENT_INTERACTIONS = new HashMap<GameEvent, Map<ResourceLocation, ObeliskInteraction>>();
    public static List<ObeliskInteraction> RIGHT_CLICK_INTERACTIONS = new ArrayList<ObeliskInteraction>();
    public static Multimap<Injection, ObeliskInteraction> RESPAWN_INTERACTIONS = HashMultimap.create();
    public static ObeliskInteraction DEFAULT_CHARGING = ObeliskInteraction.ofClick(new ResourceLocation("respawnobelisks", "default_charging"), (TriFunction<Player, ItemStack, RespawnObeliskBlockEntity, Boolean>)((TriFunction)(player, stack, be) -> {
        if (!ChargeConfig.getChargeItems().containsKey(stack.m_41720_())) {
            return false;
        }
        double charge = ChargeConfig.getChargeItems().get(stack.m_41720_());
        double currentCharge = be.getCharge((Player)player);
        if (currentCharge + charge > be.getMaxCharge((Player)player)) {
            return false;
        }
        ChargeConfig.getChargeItems().keySet().forEach(i -> player.m_36335_().m_41524_(i, 30));
        be.chargeAndAnimate((Player)player, charge);
        if (!player.m_150110_().f_35937_) {
            player.m_21205_().m_41774_(1);
        }
        return true;
    }));
    public static ObeliskInteraction INFINITE_CHARGE = ObeliskInteraction.ofRespawn(new ResourceLocation("respawnobelisks", "infinite_charge"), Injection.START, (TriConsumer<Player, RespawnObeliskBlockEntity, Manager>)((TriConsumer)(player, be, manager) -> {
        if (!be.m_58898_()) {
            return;
        }
        Block block = Registry.f_122824_.m_6612_(new ResourceLocation(ChargeConfig.infiniteChargeBlock)).orElse(Blocks.f_50273_);
        boolean isInfinite = block.getClass().isInstance(be.m_58904_().m_8055_(be.m_58899_().m_7495_()).m_60734_());
        if (isInfinite) {
            manager.cost = 0.0;
        }
    }));
    public static ObeliskInteraction TELEPORT = new ObeliskInteraction(new ResourceLocation("respawnobelisks", "teleportation"));
    public static ObeliskInteraction REVIVE = new ObeliskInteraction(new ResourceLocation("respawnobelisks", "revival"));
    public static ObeliskInteraction PROTECT = new ObeliskInteraction(new ResourceLocation("respawnobelisks", "player_protection"));
    public static ObeliskInteraction SAVE_INV = new ObeliskInteraction(new ResourceLocation("respawnobelisks", "item_keeping"));
    public final ResourceLocation id;
    public final BiFunction<RespawnObeliskBlockEntity, GameEvent.Message, Boolean> eventHandler;
    public final TriFunction<Player, ItemStack, RespawnObeliskBlockEntity, Boolean> clickHandler;
    public final TriConsumer<Player, RespawnObeliskBlockEntity, Manager> respawnHandler;

    private ObeliskInteraction(GameEvent event, ResourceLocation id, BiFunction<RespawnObeliskBlockEntity, GameEvent.Message, Boolean> handler) {
        this.id = id;
        this.eventHandler = handler;
        this.clickHandler = (p, i, b) -> false;
        this.respawnHandler = (p, be, m) -> {};
        if (!EVENT_INTERACTIONS.containsKey(event)) {
            EVENT_INTERACTIONS.put(event, new HashMap());
        }
        EVENT_INTERACTIONS.get(event).put(id, this);
    }

    private ObeliskInteraction(ResourceLocation id, TriFunction<Player, ItemStack, RespawnObeliskBlockEntity, Boolean> handler) {
        this.id = id;
        this.eventHandler = (be, message) -> false;
        this.clickHandler = handler;
        this.respawnHandler = (p, be, m) -> {};
        RIGHT_CLICK_INTERACTIONS.add(this);
    }

    private ObeliskInteraction(ResourceLocation id, Injection injection, TriConsumer<Player, RespawnObeliskBlockEntity, Manager> handler) {
        this.id = id;
        this.eventHandler = (be, message) -> false;
        this.clickHandler = (p, i, be) -> false;
        this.respawnHandler = handler;
        RESPAWN_INTERACTIONS.put((Object)injection, (Object)this);
    }

    public ObeliskInteraction(ResourceLocation id) {
        this.id = id;
        this.eventHandler = (be, message) -> false;
        this.clickHandler = (p, i, be) -> false;
        this.respawnHandler = (p, be, m) -> {};
    }

    public static ObeliskInteraction ofEvent(ResourceLocation id, GameEvent event, BiFunction<RespawnObeliskBlockEntity, GameEvent.Message, Boolean> handler) {
        return new ObeliskInteraction(event, id, handler);
    }

    public static ObeliskInteraction ofEvent(String id, String event, LuaFunction handler) {
        return new ObeliskInteraction((GameEvent)Registry.f_175412_.m_7745_(new ResourceLocation(event)), new ResourceLocation(id), (be, message) -> handler.call(CoerceJavaToLua.coerce((Object)((Object)new ROBEReference((RespawnObeliskBlockEntity)((Object)be)))), CoerceJavaToLua.coerce((Object)new GameEventReference.Message(message))).toboolean());
    }

    public static ObeliskInteraction ofClick(ResourceLocation id, TriFunction<Player, ItemStack, RespawnObeliskBlockEntity, Boolean> handler) {
        return new ObeliskInteraction(id, handler);
    }

    public static ObeliskInteraction ofClick(String id, LuaFunction handler) {
        return new ObeliskInteraction(new ResourceLocation(id), (TriFunction<Player, ItemStack, RespawnObeliskBlockEntity, Boolean>)((TriFunction)(player, item, be) -> handler.call(CoerceJavaToLua.coerce((Object)new PlayerReference(player)), CoerceJavaToLua.coerce((Object)new ItemStackReference(item)), CoerceJavaToLua.coerce((Object)((Object)new ROBEReference((RespawnObeliskBlockEntity)((Object)be))))).toboolean()));
    }

    public static ObeliskInteraction ofRespawn(ResourceLocation id, Injection injection, TriConsumer<Player, RespawnObeliskBlockEntity, Manager> handler) {
        return new ObeliskInteraction(id, injection, handler);
    }

    public static ObeliskInteraction ofRespawn(String id, Injection injection, LuaFunction handler) {
        return new ObeliskInteraction(new ResourceLocation(id), injection, (TriConsumer<Player, RespawnObeliskBlockEntity, Manager>)((TriConsumer)(player, be, manager) -> handler.call(CoerceJavaToLua.coerce((Object)new PlayerReference(player)), CoerceJavaToLua.coerce((Object)((Object)new ROBEReference((RespawnObeliskBlockEntity)((Object)be)))), CoerceJavaToLua.coerce((Object)manager))));
    }

    public static enum Injection {
        START,
        END;

    }

    public static class Manager {
        public double cost;
        public Vec3 spawnLoc;

        public Manager(double cost, Vec3 spawnLoc) {
            this.cost = cost;
            this.spawnLoc = spawnLoc;
        }

        public double getCost() {
            return this.cost;
        }

        public void setCost(double cost) {
            this.cost = cost;
        }

        public Vec3 getSpawnLocActual() {
            return this.spawnLoc;
        }

        public Vec3Reference getSpawnLoc() {
            return new Vec3Reference(this.spawnLoc);
        }

        public void setSpawnLoc(Vec3 spawnLoc) {
            this.spawnLoc = spawnLoc;
        }

        public void setSpawnLoc(Vec3Reference ref) {
            this.spawnLoc = (Vec3)ref.instance;
        }
    }
}

